// Fire Works by WyldAnimal
// Adapted from 
// https://www.shadertoy.com/view/4dBGRw
//

// Totem uses a different set of variables
uniform float u_Elapsed; // Replace all iGlobalTime with u_Elapsed
uniform vec2 u_WindowSize; // Replace all iResolution with u_WindowSize
uniform sampler2D texture0; // Replace all iChannel0 with Texture0 

// controls the burst Pattern
// for a regular pattern use the 1.0 for all
#define burst1 1.2
#define burst2 1.1
#define burst3 1.0
#define burst4 1.3

// particle fade controls 
#define fade1 0.0
#define fade2 0.5
#define fadespeed 2.0

#define nightsky_r 0.02
#define nightsky_g 0.01
#define nightsky_b 0.01
#define horizon 0.1

float rand(float val, float seed){
	return cos(val*sin(val*seed)*seed);	
}

//Use one or the other
float distance2( in vec2 a, in vec2 b ) { return dot(a-b,a-b); }
//float distance2( in vec2 a, in vec2 b ) { return dot(b-a,b-a); }

// try one or the other lines below. ( one must be commented out)
//float distance3( in vec2 a, in vec2 b ) { return dot(a-b,a-b); }
float distance3( in vec2 a, in vec2 b ) { return dot(b-a,b-a); }


mat2 rr = mat2( cos(burst1), -sin(burst2), sin(burst3), cos(burst4) );

vec3 drawParticles(vec2 pos, vec3 particolor, float time, vec2 cpos, float gravity, float seed, float timelength){
    vec3 col= vec3(0.0);
    vec2 pp = vec2(1.0,0.0);
    for(float i=1.0;i<=32.0;i++){
        float d=rand(i, seed);
        float fade=(i/128.0)*time;
        vec2 particpos = cpos + time*pp*d;
        pp = rr*pp;
        col = mix(particolor/fade, col, smoothstep(0.0, 0.00003, distance2(particpos, pos)));
        col*= mix(particolor*fade, col, smoothstep(0.0, 0.0002, distance3(particpos, pos)));

    }
    col*=smoothstep(fade1,fade2,(timelength-time)/(timelength*fadespeed));
	
    return col;
}
vec3 drawFireworks(float time, vec2 uv, vec3 particolor, float seed){
	
	float timeoffset = 0.2;
	vec3 col=vec3(0.0);
	if(time<=0.){
		return col;	
	}
	if(mod(time, 6.0)>timeoffset){
	col= drawParticles(uv, particolor, mod(time, 6.0)-timeoffset, vec2(rand(ceil(time/6.0),seed),-0.5), 0.5, ceil(time/6.0), seed);
	}
	return col;	
}

void main(void)
{
	vec2 uv =1.0 -  2.0* gl_FragCoord.xy / u_WindowSize.xy;
	uv.x *= u_WindowSize.x/u_WindowSize.y;
	vec3 col=vec3(nightsky_r,nightsky_g,nightsky_b);
	col += horizon*uv.y;
	
	
	col += drawFireworks(u_Elapsed    , uv+0.0,vec3(1.0,0.1,0.1), 1.); // red
	col += drawFireworks(u_Elapsed-2.0, uv-0.1,vec3(0.0,1.0,0.5), 2.); // green
	col += drawFireworks(u_Elapsed-2.5, uv+0.1,vec3(0.0,0.2,1.5), 2.5); // blue
	col += drawFireworks(u_Elapsed-3.0, uv-0.02,vec3(1.0,1.0,1.0), 3.); // white
	col += drawFireworks(u_Elapsed-4.0, uv+0.3,vec3(1.0,1.0,0.5), 1.5); // yellow
	col += drawFireworks(u_Elapsed-3.5, uv-0.3,vec3(1.0,0.1,1.0), 3.5); // purple
	
		gl_FragColor = vec4(col,1.0);
}